import { NextRequest,NextResponse } from "next/server";
import { prisma } from '@/lib/prismaconfig'

export async function GET(req) {
  const type = req.nextUrl.searchParams.get("type");
  console.log("GET:", type);
  return NextResponse.json([{ title: "test" }, { title: "test1" }]);
}

export async function POST(req) {
  const data = await req.json();
  console.log("POST:", data);
  return NextResponse.json({ message: "POST received" });
}

export async function PUT(req) {
  const data = await req.json();
  console.log("PUT:", data);
  return NextResponse.json({ message: "PUT received", data });
}

export async function DELETE(req) {
  const id = req.nextUrl.searchParams.get("id");
  console.log("DELETE:", id);
  return NextResponse.json({ message: `Deleted item with ID: ${id}` });
}

export async function PATCH(req) {
  const data = await req.json();
  console.log("PATCH:", data);
  return NextResponse.json({ message: "PATCH received", data });
}
